/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.adapters;

import android.database.Cursor;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.learnpainless.core.callbacks.OnSwipeListener;

public abstract class RecyclerCursorAdapter<U, V extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements OnSwipeListener {
    public static final int HEADER_COUNT = 1;
    public static final int FOOTER_COUNT = 1;
    protected OnChangedListener<U> onChangedListener;
    private View mEmptyView;
    private Cursor mCursor;
    private boolean isValid;
    private int indexColumnId;

    public Cursor getCursor() {
        return this.mCursor;
    }

    public void setModifiedListener(OnChangedListener<U> onChangedListener) {
        this.onChangedListener = onChangedListener;
    }

    public void setDataSource(Cursor cursor) {
        if (this.mCursor == null) {
            this.createCursor(cursor);
        } else {
            this.swapCursor(cursor);
        }
        this.toggleEmptyView();
    }

    private void createCursor(Cursor cursor) {
        this.mCursor = cursor;
        this.isValid = cursor != null;
        this.indexColumnId = this.isValid ? this.mCursor.getColumnIndex("_id") : -1;
        this.notifyItemRangeInserted(this.getPositionForNotifyItemRangeXXX(), this.getCount());
    }

    public void swapCursor(Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return;
        }
        Cursor oldCursor = this.mCursor;
        this.mCursor = newCursor;
        if (this.mCursor != null) {
            this.indexColumnId = newCursor.getColumnIndexOrThrow("_id");
            this.isValid = true;
            this.notifyDataSetChanged();
        } else {
            this.indexColumnId = -1;
            this.isValid = false;
            this.notifyItemRangeRemoved(this.getPositionForNotifyItemRangeXXX(), this.getCount());
        }
        if (oldCursor != null) {
            oldCursor.close();
        }
    }

    public int getPositionForNotifyItemRangeXXX() {
        return this.hasHeader() ? 1 : 0;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void toggleEmptyView() {
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(this.getCount() == 0 ? 0 : 8);
        }
    }

    public final int getCount() {
        return this.isValid ? this.mCursor.getCount() : 0;
    }

    public long getItemId(int position) {
        if (this.isItem(position) && this.isValid && this.mCursor.moveToPosition(position)) {
            return this.mCursor.getLong(this.indexColumnId);
        }
        return -1L;
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(true);
    }

    public final int getItemCount() {
        int itemCount = 0;
        if (this.hasHeader()) {
            ++itemCount;
        }
        if (this.hasFooter()) {
            ++itemCount;
        }
        return itemCount += this.getCount();
    }

    public final int getItemViewType(int position) {
        if (this.isHeader(position)) {
            return Type.HEADER.ordinal();
        }
        if (this.isFooter(position)) {
            return Type.FOOTER.ordinal();
        }
        return Type.ITEM.ordinal();
    }

    public boolean isHeader(int position) {
        return this.hasHeader() && position == 0;
    }

    public boolean isFooter(int position) {
        int headerCount = this.hasHeader() ? 1 : 0;
        return this.hasFooter() && position > this.getCount() + headerCount;
    }

    public boolean isItem(int position) {
        return !this.isHeader(position) && !this.isFooter(position);
    }

    public final RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == Type.HEADER.ordinal()) {
            return this.onCreate(parent, Type.HEADER.ordinal());
        }
        if (viewType == Type.FOOTER.ordinal()) {
            return this.onCreate(parent, Type.FOOTER.ordinal());
        }
        return this.onCreate(parent, Type.ITEM.ordinal());
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.isItem(position)) {
            int headerCount = this.hasHeader() ? 1 : 0;
            U object = this.getObjectAt(position - headerCount);
            this.onBind(holder, object, this.getItemViewType(position));
        }
    }

    @Nullable
    public U getObjectAt(int position) {
        U object = null;
        if (this.isValid && this.mCursor.moveToPosition(position)) {
            object = this.extractFromCursor(this.mCursor);
        }
        return object;
    }

    @Override
    public void onSwipe(int position) {
        int headerCount = this.hasHeader() ? 1 : 0;
        U object = this.getObjectAt(position - headerCount);
        if (this.onChangedListener != null) {
            this.onChangedListener.onRemove(object);
        }
    }

    public abstract boolean hasHeader();

    public abstract boolean hasFooter();

    public abstract U extractFromCursor(Cursor var1);

    public abstract V onCreate(ViewGroup var1, int var2);

    public abstract void onBind(V var1, U var2, int var3);

    public static interface OnChangedListener<U> {
        public void onAdd(U var1);

        public void onRemove(U var1);
    }

    public static enum Type {
        HEADER,
        ITEM,
        FOOTER;

    }
}

