/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.fragments;

import android.app.Dialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.text.format.DateFormat;
import android.widget.TimePicker;
import java.util.Calendar;
import java.util.Locale;

public class CustomTimePickerDialog
extends DialogFragment
implements TimePickerDialog.OnTimeSetListener {
    private TimePickerResultListener timePickerResultListener;

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        int minute = c.get(12);
        return new TimePickerDialog((Context)this.getActivity(), (TimePickerDialog.OnTimeSetListener)this, hour, minute, DateFormat.is24HourFormat((Context)this.getActivity()));
    }

    public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
        if (this.timePickerResultListener != null) {
            this.timePickerResultListener.onTimeSelect(hourOfDay, minute);
            int hour = hourOfDay % 12;
            this.timePickerResultListener.onTimeSelect(String.format(Locale.ENGLISH, "%02d:%02d %s", hour == 0 ? 12 : hour, minute, hourOfDay < 12 ? "AM" : "PM"));
        }
    }

    public void setTimePickerResultListener(TimePickerResultListener timePickerResultListener) {
        this.timePickerResultListener = timePickerResultListener;
    }

    public static interface TimePickerResultListener {
        public void onTimeSelect(int var1, int var2);

        public void onTimeSelect(String var1);
    }
}

