/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.tasks;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;

public class DownloadFileFromUrl
extends AsyncTask<Void, String, String> {
    private WeakReference<Context> contextWeakReference;
    private WeakReference<String> urlWeakReference;
    private WeakReference<String> folderWeakReference;
    private static boolean downloadStatus = true;

    public DownloadFileFromUrl(Context context, String folder, String url) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.urlWeakReference = new WeakReference<String>(url);
        this.folderWeakReference = new WeakReference<String>(folder);
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected String doInBackground(Void ... voids) {
        File myFile = null;
        try {
            int count;
            File storagePath;
            URL url = new URL((String)this.urlWeakReference.get());
            URLConnection connection = url.openConnection();
            connection.connect();
            int lengthOfFile = connection.getContentLength();
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream(), 10240);
            if (String.valueOf(url).contains("gif")) {
                storagePath = new File(Environment.getExternalStorageDirectory() + "/" + (String)this.folderWeakReference.get() + "/gif");
                storagePath.mkdirs();
                myFile = new File(storagePath, "IMG_" + Long.toString(System.currentTimeMillis()) + ".gif");
            } else if (String.valueOf(url).contains("jpg")) {
                storagePath = new File(Environment.getExternalStorageDirectory() + "/" + (String)this.folderWeakReference.get() + "/images");
                storagePath.mkdirs();
                myFile = new File(storagePath, "IMG_" + Long.toString(System.currentTimeMillis()) + ".jpg");
            } else if (String.valueOf(url).contains("mp4")) {
                storagePath = new File(Environment.getExternalStorageDirectory() + "/" + (String)this.folderWeakReference.get() + "/videos");
                storagePath.mkdirs();
                myFile = new File(storagePath, "VID_" + Long.toString(System.currentTimeMillis()) + ".mp4");
            }
            FileOutputStream outputStream = new FileOutputStream(myFile);
            byte[] data = new byte[1024];
            long total = 0L;
            while ((count = ((InputStream)inputStream).read(data)) != 1 && !this.isCancelled() && downloadStatus) {
                this.publishProgress(new String[]{"" + (int)((total += (long)count) * 100L / (long)lengthOfFile)});
                ((OutputStream)outputStream).write(data, 0, count);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)e.getMessage());
        }
        return myFile != null ? myFile.getAbsolutePath() : null;
    }

    protected void onProgressUpdate(String ... progress) {
        ProgressDialog progressDialog = new ProgressDialog((Context)this.contextWeakReference.get());
        progressDialog.setTitle((CharSequence)"Please wait");
        progressDialog.setProgress(Integer.parseInt(progress[0]));
        progressDialog.setCancelable(false);
        progressDialog.setButton(-2, (CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadFileFromUrl.this.cancel(true);
                downloadStatus = false;
                dialog.cancel();
            }
        });
        progressDialog.show();
    }

    public void onPostExecute(String file_url) {
        if (file_url != null) {
            MediaScannerConnection.scanFile((Context)((Context)this.contextWeakReference.get()), (String[])new String[]{file_url}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                public void onScanCompleted(String path, Uri uri) {
                }
            });
        }
    }
}

