/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.provider.MediaStore;
import android.support.annotation.AnimRes;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.ViewPager;
import android.text.format.DateUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ScrollView;
import android.widget.Spinner;
import com.learnpainless.core.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Random;

public class LPLUtils {
    public static String getRealPathFromURI(Uri contentUri, Context context) {
        String[] proj = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
        if (cursor == null) {
            return contentUri.getPath();
        }
        cursor.moveToFirst();
        int index = cursor.getColumnIndex("_data");
        String value = cursor.getString(index);
        cursor.close();
        return value;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "");
        return String.format(Locale.ENGLISH, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    private static String getThumbName() {
        File file = new File(Environment.getExternalStorageDirectory().getPath(), "/.Thumb");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath() + "/" + System.currentTimeMillis() + ".jpg";
    }

    public static String saveThumbnail(Bitmap bitmap) {
        String filename = LPLUtils.getThumbName();
        File f = new File(filename);
        try {
            f.createNewFile();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            byte[] bitmapdata = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bitmapdata);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f.getAbsolutePath();
    }

    public static CharSequence convertTimestamp(long milliSeconds) {
        return DateUtils.getRelativeTimeSpanString((long)milliSeconds, (long)System.currentTimeMillis(), (long)1000L);
    }

    public static int getRandomColor() {
        Random rand = new Random();
        return Color.rgb((int)rand.nextInt(256), (int)rand.nextInt(256), (int)rand.nextInt(256));
    }

    public static Bitmap getBitmapFromUri(Context context, Uri uri) throws IOException {
        return MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
    }

    public static void replaceFragment(FragmentActivity activity, Fragment fragment, @IdRes int containerId) {
        String backStateName = fragment.getClass().getName();
        FragmentManager manager = activity.getSupportFragmentManager();
        boolean fragmentPopped = manager.popBackStackImmediate(backStateName, 0);
        if (!fragmentPopped && manager.findFragmentByTag(backStateName) == null) {
            FragmentTransaction ft = manager.beginTransaction();
            ft.addToBackStack(backStateName);
            ft.setCustomAnimations(0x10A0000, 0x10A0001);
            ft.replace(containerId, fragment, backStateName);
            ft.commit();
            manager.executePendingTransactions();
        }
    }

    public static void replaceFragment(FragmentActivity activity, Fragment fragment, @IdRes int containerId, @AnimRes int enter, @AnimRes int exit, @AnimRes int popEnter, @AnimRes int popExit) {
        String backStateName = fragment.getClass().getName();
        FragmentManager manager = activity.getSupportFragmentManager();
        boolean fragmentPopped = manager.popBackStackImmediate(backStateName, 0);
        if (!fragmentPopped && manager.findFragmentByTag(backStateName) == null) {
            FragmentTransaction ft = manager.beginTransaction();
            ft.addToBackStack(backStateName);
            ft.setCustomAnimations(enter, exit, popEnter, popExit);
            ft.replace(containerId, fragment, backStateName);
            ft.commit();
        }
    }

    public static ScreenModel getScreenSize(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return new ScreenModel(displayMetrics.heightPixels, displayMetrics.widthPixels);
    }

    public static ProgressDialog showProgress(Context context, String message) {
        return ProgressDialog.show((Context)context, null, (CharSequence)message, (boolean)true, (boolean)false);
    }

    public static ProgressDialog showProgress(Context context) {
        return LPLUtils.showProgress(context, context.getString(R.string.wait));
    }

    public static void hideProgress(ProgressDialog progressDialog) {
        if (progressDialog != null && progressDialog.isShowing()) {
            progressDialog.dismiss();
        }
    }

    public static void setSpinnerText(Spinner spinner, String text) {
        for (int i = 0; i < spinner.getAdapter().getCount(); ++i) {
            if (!spinner.getAdapter().getItem(i).toString().equalsIgnoreCase(text)) continue;
            spinner.setSelection(i);
        }
    }

    public static Fragment getViewPagerFragment(FragmentManager fragmentManager, ViewPager container, int position) {
        String name = LPLUtils.makeFragmentName(container.getId(), position);
        return fragmentManager.findFragmentByTag(name);
    }

    private static String makeFragmentName(int viewId, int index) {
        return "android:switcher:" + viewId + ":" + index;
    }

    public static void focusOnView(final ScrollView scrollView, final View view) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                scrollView.scrollTo(0, view.getTop());
            }
        });
    }

    public static void focusOnViewBottom(final ScrollView scrollView, final View view) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                scrollView.scrollTo(0, view.getBottom());
            }
        });
    }

    public static class ScreenModel {
        int height;
        int width;

        public ScreenModel(int height, int width) {
            this.height = height;
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

