/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AlertDialog;
import com.learnpainless.core.R;

public class NetworkUtils {
    public static boolean isConnectionAvailable(Context context) {
        NetworkInfo netInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager != null && (netInfo = connectivityManager.getActiveNetworkInfo()) != null && netInfo.isConnected() && netInfo.isConnectedOrConnecting() && netInfo.isAvailable();
    }

    public static boolean isConnectionAvailable(Context context, boolean showPopup) {
        if (NetworkUtils.isConnectionAvailable(context)) {
            return true;
        }
        if (showPopup) {
            AlertDialog.Builder dialog = new AlertDialog.Builder(context);
            dialog.setTitle(R.string.connection_title);
            dialog.setMessage(R.string.no_connection);
            dialog.setCancelable(false);
            dialog.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
            dialog.show();
        }
        return false;
    }
}

