/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.views;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.learnpainless.core.R;

public class CircleProgressBar
extends View {
    private float strokeWidth = 4.0f;
    private float progress = 0.0f;
    private int min = 0;
    private int max = 100;
    private int startAngle = -90;
    private int color = -12303292;
    private RectF rectF;
    private Paint backgroundPaint;
    private Paint foregroundPaint;

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.backgroundPaint.setStrokeWidth(strokeWidth);
        this.foregroundPaint.setStrokeWidth(strokeWidth);
        this.invalidate();
        this.requestLayout();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.invalidate();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.invalidate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color2) {
        this.color = color2;
        this.backgroundPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        this.foregroundPaint.setColor(color2);
        this.invalidate();
        this.requestLayout();
    }

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.rectF = new RectF();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleProgressBar, 0, 0);
        try {
            this.strokeWidth = typedArray.getDimension(R.styleable.CircleProgressBar_progressBarThickness, this.strokeWidth);
            this.progress = typedArray.getFloat(R.styleable.CircleProgressBar_progress, this.progress);
            this.color = typedArray.getInt(R.styleable.CircleProgressBar_progressbarColor, this.color);
            this.min = typedArray.getInt(R.styleable.CircleProgressBar_min, this.min);
            this.max = typedArray.getInt(R.styleable.CircleProgressBar_max, this.max);
        }
        finally {
            typedArray.recycle();
        }
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        this.backgroundPaint.setStyle(Paint.Style.STROKE);
        this.backgroundPaint.setStrokeWidth(this.strokeWidth);
        this.foregroundPaint = new Paint(1);
        this.foregroundPaint.setColor(this.color);
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setStrokeWidth(this.strokeWidth);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawOval(this.rectF, this.backgroundPaint);
        float angle = 360.0f * this.progress / (float)this.max;
        canvas.drawArc(this.rectF, (float)this.startAngle, angle, false, this.foregroundPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = CircleProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = CircleProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        this.rectF.set(0.0f + this.strokeWidth / 2.0f, 0.0f + this.strokeWidth / 2.0f, (float)min - this.strokeWidth / 2.0f, (float)min - this.strokeWidth / 2.0f);
    }

    public int lightenColor(int color2, float factor) {
        float r = (float)Color.red((int)color2) * factor;
        float g = (float)Color.green((int)color2) * factor;
        float b = (float)Color.blue((int)color2) * factor;
        int ir = Math.min(255, (int)r);
        int ig = Math.min(255, (int)g);
        int ib = Math.min(255, (int)b);
        int ia = Color.alpha((int)color2);
        return Color.argb((int)ia, (int)ir, (int)ig, (int)ib);
    }

    public int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public void setProgressWithAnimation(float progress) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{progress});
        objectAnimator.setDuration(1500L);
        objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimator.start();
    }
}

