/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;

public abstract class CoreAdapter<LPL, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    protected ArrayList<LPL> arrayList;
    protected Context context;
    protected LayoutInflater layoutInflater;
    protected Activity activity;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;

    public CoreAdapter(Context context) {
        this(context, new ArrayList());
    }

    public CoreAdapter(Context context, ArrayList<LPL> arrayList) {
        this.arrayList = arrayList;
        this.context = context;
        this.activity = (Activity)context;
        this.layoutInflater = LayoutInflater.from((Context)context);
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public void swap(int pos1, int pos2) {
        Collections.swap(this.arrayList, pos1, pos2);
        this.notifyItemMoved(pos1, pos2);
    }

    public int getCount() {
        return this.arrayList.size();
    }

    public LPL getItem(int position) {
        return this.arrayList.get(position);
    }

    public void updateList(ArrayList<LPL> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    public void add(LPL item) {
        this.arrayList.add(item);
        this.notifyItemInserted(this.arrayList.size() - 1);
    }

    public void addList(ArrayList<LPL> arrayList) {
        if (this.arrayList != null) {
            this.arrayList.addAll(this.arrayList.size(), arrayList);
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        this.arrayList.clear();
        this.notifyDataSetChanged();
    }

    public ArrayList<LPL> getList() {
        return this.arrayList;
    }

    public void remove(LPL item) {
        this.arrayList.remove(item);
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(View var1, int var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2, int var3);
    }
}

