/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.fragments;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.widget.DatePicker;
import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import java.util.Calendar;
import java.util.Locale;

public class CustomDatePickerDialog
extends DialogFragment
implements DatePickerDialog.OnDateSetListener {
    private DatePickerResultListener datePickerResultListener;
    private String divider = "/";

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Calendar calendar = Calendar.getInstance();
        int yy = calendar.get(1);
        int mm = calendar.get(2);
        int dd = calendar.get(5);
        return new DatePickerDialog((Context)this.getActivity(), (DatePickerDialog.OnDateSetListener)this, yy, mm, dd);
    }

    public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
        if (this.datePickerResultListener != null) {
            this.datePickerResultListener.onDateSelect(year, month + 1, dayOfMonth);
            this.datePickerResultListener.onDateSelect(String.format(Locale.ENGLISH, "%02d%s%02d%s%d", dayOfMonth, this.divider, month + 1, this.divider, year));
        }
    }

    public void setDatePickerResultListener(DatePickerResultListener datePickerResultListener) {
        this.datePickerResultListener = datePickerResultListener;
    }

    public void setDivider(String divider) {
        this.divider = divider;
    }

    public static interface DatePickerResultListener {
        public void onDateSelect(int var1, int var2, int var3);

        public void onDateSelect(String var1);
    }
}

