/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.security;

import android.content.Context;
import android.util.Base64;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryption {
    private static final int KEY_SIZE = 128;
    private static final String KEY_GENERATOR_ALGORITHM = "AES";
    private static final String SECRET_KEY = "SECRET_KEY";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    private static SecretKey getSecretKey(Context context) throws NoSuchAlgorithmException {
        String secretKeyString = context.getSharedPreferences("security", 0).getString(SECRET_KEY, null);
        if (secretKeyString != null) {
            byte[] bytes = Base64.decode((String)secretKeyString, (int)0);
            return new SecretKeySpec(bytes, KEY_GENERATOR_ALGORITHM);
        }
        SecretKey secretKey = AESEncryption.newSecretKey();
        secretKeyString = Base64.encodeToString((byte[])secretKey.getEncoded(), (int)0);
        context.getSharedPreferences("security", 0).edit().putString(SECRET_KEY, secretKeyString).apply();
        return secretKey;
    }

    private static SecretKey newSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_GENERATOR_ALGORITHM);
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    public static String encrypt(Context context, String data) {
        try {
            SecretKey secretKey = AESEncryption.getSecretKey(context);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
            byte[] transformedBytes = cipher.doFinal(data.getBytes());
            return Base64.encodeToString((byte[])transformedBytes, (int)0);
        }
        catch (NoSuchAlgorithmException e) {
            return data;
        }
        catch (NoSuchPaddingException e) {
            return data;
        }
        catch (InvalidKeyException e) {
            return data;
        }
        catch (IllegalBlockSizeException e) {
            return data;
        }
        catch (BadPaddingException e) {
            return data;
        }
        catch (InvalidAlgorithmParameterException e) {
            return data;
        }
    }

    public static String decrypt(Context context, String data) {
        byte[] bytes;
        try {
            bytes = Base64.decode((String)data, (int)0);
        }
        catch (IllegalArgumentException e) {
            return data;
        }
        try {
            SecretKey secretKey = AESEncryption.getSecretKey(context);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            return new String(cipher.doFinal(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            return data;
        }
        catch (NoSuchPaddingException e) {
            return data;
        }
        catch (IllegalBlockSizeException e) {
            return data;
        }
        catch (BadPaddingException e) {
            return data;
        }
        catch (InvalidKeyException e) {
            return data;
        }
        catch (InvalidAlgorithmParameterException e) {
            return data;
        }
    }
}

