/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.tasks;

import android.content.Context;
import android.os.AsyncTask;
import com.learnpainless.core.tasks.Response;
import java.lang.ref.WeakReference;

public abstract class BaseAsyncTask<Params, Progress, T>
extends AsyncTask<Params, Progress, Response<T>> {
    private WeakReference<Response.Listener<T>> listenerWrapper;
    private WeakReference<Context> contextWrapper;

    public BaseAsyncTask(Response.Listener<T> listener, Context context) {
        this.listenerWrapper = new WeakReference<Response.Listener<Response.Listener<T>>>(listener);
        this.contextWrapper = new WeakReference<Context>(context);
    }

    protected Response.Listener<T> getListener() {
        return (Response.Listener)this.listenerWrapper.get();
    }

    protected Context getContext() {
        return (Context)this.contextWrapper.get();
    }

    protected void onPostExecute(Response<T> response) {
        Response.Listener<T> listener = this.getListener();
        if (listener != null && response != null) {
            if (response.isSuccess()) {
                listener.onResponse(response.getResult());
            } else {
                listener.onErrorResponse(response.getException());
            }
        }
    }
}

