/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.tasks;

import android.app.ProgressDialog;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import com.learnpainless.core.R;
import com.learnpainless.core.tasks.BaseAsyncTask;
import com.learnpainless.core.tasks.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class CompressImageTask
extends BaseAsyncTask<Void, String, CompressedModel> {
    private static final float maxHeight = 816.0f;
    private static final float maxWidth = 612.0f;
    private ProgressDialog dialog;
    private WeakReference<String> pathReference;

    public CompressImageTask(Response.Listener<CompressedModel> listener, Context context, String path) {
        super(listener, context);
        this.dialog = ProgressDialog.show((Context)context, null, (CharSequence)context.getString(R.string.processing), (boolean)true);
        this.pathReference = new WeakReference<String>(path);
    }

    protected Response<CompressedModel> doInBackground(Void ... params) {
        Context context = this.getContext();
        if (context != null) {
            try {
                return Response.success(this.compressImage((String)this.pathReference.get()));
            }
            catch (IOException e) {
                return Response.error(e);
            }
        }
        return null;
    }

    @Override
    protected void onPostExecute(Response<CompressedModel> response) {
        super.onPostExecute(response);
        this.dialog.dismiss();
    }

    private String getRealPathFromURI(String contentURI) {
        Uri contentUri = Uri.parse((String)contentURI);
        Cursor cursor = this.getContext().getContentResolver().query(contentUri, null, null, null, null);
        if (cursor == null) {
            return contentUri.getPath();
        }
        cursor.moveToFirst();
        int index = cursor.getColumnIndex("_data");
        String cursorString = cursor.getString(index);
        cursor.close();
        return cursorString;
    }

    private CompressedModel compressImage(String imagePath) throws OutOfMemoryError, IOException {
        if (imagePath.startsWith("content://")) {
            imagePath = this.getRealPathFromURI(imagePath);
        }
        CompressedModel model = new CompressedModel();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float imgRatio = (float)actualWidth / (float)actualHeight;
        float maxRatio = 0.75f;
        if ((float)actualHeight > 816.0f || (float)actualWidth > 612.0f) {
            if (imgRatio < maxRatio) {
                imgRatio = 816.0f / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = 816;
            } else if (imgRatio > maxRatio) {
                imgRatio = 612.0f / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = 612;
            } else {
                actualHeight = 816;
                actualWidth = 612;
            }
        }
        options.inSampleSize = CompressImageTask.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        Bitmap bmp = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        Bitmap scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
        if (bmp != null) {
            bmp.recycle();
        }
        ExifInterface exif = new ExifInterface(imagePath);
        int orientation = exif.getAttributeInt("Orientation", 0);
        Matrix matrix = new Matrix();
        if (orientation == 6) {
            matrix.postRotate(90.0f);
        } else if (orientation == 3) {
            matrix.postRotate(180.0f);
        } else if (orientation == 8) {
            matrix.postRotate(270.0f);
        }
        scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        File file = this.getImageFile();
        FileOutputStream out = new FileOutputStream(file);
        scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
        model.setBitmap(scaledBitmap);
        model.setFile(file);
        model.setPath(file.getAbsolutePath());
        out.flush();
        out.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)byteArrayOutputStream);
        model.setBytes(byteArrayOutputStream.toByteArray());
        return model;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    private File getImageFile() {
        File mediaStorageDir = new File(Environment.getExternalStorageDirectory(), ".LPL");
        if (!mediaStorageDir.exists()) {
            mediaStorageDir.mkdirs();
        }
        String mImageName = "IMG_" + String.valueOf(System.currentTimeMillis()) + ".jpg";
        return new File(mediaStorageDir, mImageName);
    }

    public class CompressedModel {
        private String path;
        private Bitmap bitmap;
        private File file;
        private byte[] bytes;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public void setBitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

