/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.utils;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class CacheManager {
    private Context context;
    private static final String TAG = CacheManager.class.getSimpleName();

    public CacheManager(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJson(Object object, Type type2, String fileName) {
        File file = new File(this.context.getCacheDir(), fileName);
        FileOutputStream outputStream = null;
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        try {
            outputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = Build.VERSION.SDK_INT >= 19 ? new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8)) : new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
            gson.toJson(object, type2, (Appendable)bufferedWriter);
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("saveUserData, FileNotFoundException e: '" + e + "'"));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("saveUserData, IOException e: '" + e + "'"));
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("saveUserData, finally, e: '" + e + "'"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readJson(Type type2, String fileName) {
        Object jsonData = null;
        File file = new File(this.context.getCacheDir(), fileName);
        FileInputStream inputStream = null;
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        try {
            inputStream = new FileInputStream(file);
            InputStreamReader streamReader = Build.VERSION.SDK_INT >= 19 ? new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8) : new InputStreamReader((InputStream)inputStream, "UTF-8");
            jsonData = gson.fromJson((Reader)streamReader, type2);
            streamReader.close();
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("loadJson, FileNotFoundException e: '" + e + "'"));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("loadJson, IOException e: '" + e + "'"));
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("loadJson, finally, e: '" + e + "'"));
                }
            }
        }
        return jsonData;
    }
}

