/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.utils;

import android.text.format.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateConverter {
    public static String getFormattedDate(long smsTimeInMillis) {
        Calendar smsTime = Calendar.getInstance();
        smsTime.setTimeInMillis(smsTimeInMillis);
        Calendar now = Calendar.getInstance();
        String timeFormatString = "h:mm aa";
        String dateTimeFormatString = "EEEE, MMMM d, h:mm aa";
        if (now.get(5) == smsTime.get(5)) {
            return "Today " + DateFormat.format((CharSequence)"h:mm aa", (Calendar)smsTime);
        }
        if (now.get(5) - smsTime.get(5) == 1) {
            return "Yesterday " + DateFormat.format((CharSequence)"h:mm aa", (Calendar)smsTime);
        }
        if (now.get(1) == smsTime.get(1)) {
            return DateFormat.format((CharSequence)"EEEE, MMMM d, h:mm aa", (Calendar)smsTime).toString();
        }
        return DateFormat.format((CharSequence)"MMMM dd yyyy, h:mm aa", (Calendar)smsTime).toString();
    }

    private static Calendar clearTimes(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }

    public static String convertSimpleDayFormat(long smsTimeInMillis) {
        Calendar today = Calendar.getInstance();
        today = DateConverter.clearTimes(today);
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(6, -1);
        yesterday = DateConverter.clearTimes(yesterday);
        Calendar last7days = Calendar.getInstance();
        last7days.add(6, -7);
        last7days = DateConverter.clearTimes(last7days);
        Calendar last30days = Calendar.getInstance();
        last30days.add(6, -30);
        last30days = DateConverter.clearTimes(last30days);
        if (smsTimeInMillis > today.getTimeInMillis()) {
            return "today";
        }
        if (smsTimeInMillis > yesterday.getTimeInMillis()) {
            return "yesterday";
        }
        if (smsTimeInMillis > last7days.getTimeInMillis()) {
            return "last7days";
        }
        if (smsTimeInMillis > last30days.getTimeInMillis()) {
            return "last30days";
        }
        return "morethan30days";
    }

    public static String convertFormat(String oldFormat, String newFormat, String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(oldFormat, Locale.ENGLISH);
        Date parse = simpleDateFormat.parse(date);
        simpleDateFormat.applyPattern(newFormat);
        return simpleDateFormat.format(parse);
    }
}

