/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.utils;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.material.textfield.TextInputLayout;
import com.learnpainless.core.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationUtils {
    private static final int FULL_NAME_MIN_LENGTH = 3;
    private static final int FULL_NAME_MAX_LENGTH = 50;
    private static final int PASSWORD_MIN_LENGTH = 8;
    private Context context;

    public ValidationUtils(Context context) {
        this.context = context;
    }

    public boolean isLoginDataValid(TextInputLayout emailTextInputLayout, TextInputLayout passwordTextInputLayout, String email, String password) {
        boolean isPasswordEntered;
        boolean isEmailEntered = !TextUtils.isEmpty((CharSequence)email.trim());
        boolean bl = isPasswordEntered = !TextUtils.isEmpty((CharSequence)password.trim());
        if (isEmailEntered && isPasswordEntered) {
            boolean valid = true;
            if (!this.isEmailValid(email)) {
                valid = false;
                emailTextInputLayout.setErrorEnabled(true);
                emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_email_field_is_incorrect));
            }
            if (password.length() < 8) {
                valid = false;
                passwordTextInputLayout.setErrorEnabled(true);
                passwordTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_password_field_is_too_short));
            }
            return valid;
        }
        if (!isEmailEntered && !isPasswordEntered) {
            emailTextInputLayout.setErrorEnabled(true);
            passwordTextInputLayout.setErrorEnabled(true);
            emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_not_all_fields_entered));
            passwordTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_not_all_fields_entered));
        } else {
            if (!isEmailEntered) {
                emailTextInputLayout.setErrorEnabled(true);
                emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_email_field_not_entered));
            }
            if (!isPasswordEntered) {
                passwordTextInputLayout.setErrorEnabled(true);
                passwordTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_password_field_not_entered));
            }
        }
        return false;
    }

    public boolean isEmailValid(TextInputLayout emailTextInputLayout, String email) {
        boolean isEmailEntered;
        boolean bl = isEmailEntered = !TextUtils.isEmpty((CharSequence)email.trim());
        if (isEmailEntered) {
            if (!this.isEmailValid(email)) {
                emailTextInputLayout.setErrorEnabled(true);
                emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_email_field_is_incorrect));
                return false;
            }
            emailTextInputLayout.setErrorEnabled(false);
            return true;
        }
        emailTextInputLayout.setErrorEnabled(true);
        emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_email_field_not_entered));
        return false;
    }

    public boolean isSignUpDataValid(TextInputLayout fullNameTextInputLayout, TextInputLayout emailTextInputLayout, TextInputLayout passwordTextInputLayout, String fullName, String email, String password) {
        boolean isPasswordEntered;
        boolean isFullNameEntered = !TextUtils.isEmpty((CharSequence)fullName.trim());
        boolean isEmailEntered = !TextUtils.isEmpty((CharSequence)email.trim());
        boolean bl = isPasswordEntered = !TextUtils.isEmpty((CharSequence)password.trim());
        if (isFullNameEntered && isEmailEntered && isPasswordEntered) {
            boolean valid = true;
            if (fullName.length() < 3) {
                valid = false;
                fullNameTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_full_name_field_is_too_short));
            } else if (fullName.length() > 50) {
                valid = false;
                fullNameTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_full_name_field_is_too_long));
            }
            if (!this.isEmailValid(email)) {
                valid = false;
                emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_email_field_is_incorrect));
            }
            if (password.length() < 8) {
                valid = false;
                passwordTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_password_field_is_too_short));
            }
            return valid;
        }
        if (!(isFullNameEntered || isEmailEntered || isPasswordEntered)) {
            fullNameTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_not_all_fields_entered));
            emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_not_all_fields_entered));
            passwordTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_not_all_fields_entered));
        } else {
            if (!isFullNameEntered) {
                fullNameTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_full_name_field_not_entered));
            }
            if (!isEmailEntered) {
                emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_email_field_not_entered));
            }
            if (!isPasswordEntered) {
                passwordTextInputLayout.setError((CharSequence)this.context.getString(R.string.auth_password_field_not_entered));
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFullNameValid(TextInputLayout fullNameTextInputLayout, String oldFullName, String newFullName) {
        boolean fullNameEntered;
        boolean bl = fullNameEntered = !TextUtils.isEmpty((CharSequence)newFullName.trim());
        if (fullNameEntered) {
            if (!newFullName.equals(oldFullName)) return true;
            fullNameTextInputLayout.setError((CharSequence)this.context.getString(R.string.profile_full_name_not_changed));
            return false;
        } else {
            fullNameTextInputLayout.setError((CharSequence)this.context.getString(R.string.profile_full_name_not_entered));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isForgotPasswordDataValid(TextInputLayout emailTextInputLayout, String email) {
        boolean isEmailEntered;
        boolean bl = isEmailEntered = !TextUtils.isEmpty((CharSequence)email.trim());
        if (isEmailEntered) {
            if (this.isEmailValid(email)) return true;
            emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.forgot_password_email_field_is_incorrect));
            return false;
        } else {
            emailTextInputLayout.setError((CharSequence)this.context.getString(R.string.forgot_password_email_field_not_entered));
        }
        return false;
    }

    public boolean isEmailValid(String email) {
        String expression = "^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$";
        Pattern pattern = Pattern.compile(expression, 2);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }
}

