/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

public class EmptyRecyclerView
extends RecyclerView {
    @Nullable
    View emptyView;
    @NonNull
    final RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            EmptyRecyclerView.this.checkIfEmpty();
        }
    };

    public EmptyRecyclerView(Context context) {
        super(context);
    }

    public EmptyRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EmptyRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    void checkIfEmpty() {
        if (this.emptyView != null) {
            this.emptyView.setVisibility(this.getAdapter().getItemCount() > 0 ? 8 : 0);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.checkIfEmpty();
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        RecyclerView.Adapter oldAdapter = this.getAdapter();
        if (oldAdapter != null) {
            oldAdapter.unregisterAdapterDataObserver(this.observer);
        }
        super.setAdapter(adapter);
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.observer);
        }
        this.checkIfEmpty();
    }

    public void setEmptyView(@Nullable View emptyView) {
        this.emptyView = emptyView;
        this.checkIfEmpty();
    }

    public void swapAdapter(RecyclerView.Adapter adapter, boolean removeAndRecycleExistingViews) {
        RecyclerView.Adapter oldAdapter = this.getAdapter();
        if (oldAdapter != null) {
            oldAdapter.unregisterAdapterDataObserver(this.observer);
        }
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.observer);
        }
        super.swapAdapter(adapter, removeAndRecycleExistingViews);
        this.checkIfEmpty();
    }
}

