/*
 * Decompiled with CFR 0.152.
 */
package com.learnpainless.core.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;

public class RoundedImageView
extends AppCompatImageView {
    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Bitmap b = ((BitmapDrawable)drawable2).getBitmap();
        Bitmap bitmap = b.copy(Bitmap.Config.ARGB_8888, true);
        int w = this.getWidth();
        int h = this.getHeight();
        Bitmap roundBitmap = RoundedImageView.getCroppedBitmap(bitmap, w);
        canvas.drawBitmap(roundBitmap, 0.0f, 0.0f, null);
    }

    public static Bitmap getCroppedBitmap(Bitmap bmp, int radius) {
        Bitmap sbmp;
        if (bmp.getWidth() != radius || bmp.getHeight() != radius) {
            float smallest = Math.min(bmp.getWidth(), bmp.getHeight());
            float factor = smallest / (float)radius;
            sbmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)((int)((float)bmp.getWidth() / factor)), (int)((int)((float)bmp.getHeight() / factor)), (boolean)false);
        } else {
            sbmp = bmp;
        }
        Bitmap output = Bitmap.createBitmap((int)radius, (int)radius, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        String color2 = "#BAB399";
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, radius, radius);
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(Color.parseColor((String)"#BAB399"));
        canvas.drawCircle((float)(radius / 2) + 0.7f, (float)(radius / 2) + 0.7f, (float)(radius / 2) + 0.1f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(sbmp, rect, rect, paint);
        return output;
    }
}

